#!/bin/bash
# wstrings.sh: "word-strings" (  "strings")
#
#       "strings"    
#+     .
#     ""  "",
#+     .

# =================================================================
#                    
ARGS=1
E_BADARGS=65
E_NOFILE=66

if [ $# -ne $ARGS ]
then
  echo " : `basename $0` filename"
  exit $E_BADARGS
fi

if [ ! -f "$1" ]                      #   .
then
    echo " \"$1\"  ."
    exit $E_NOFILE
fi
# =================================================================


MINSTRLEN=3                           #    .
WORDFILE=/usr/share/dict/linux.words  #   .
                                      #    
                                      #+  
                                      #+   -- "   ".


wlist=`strings "$1" | tr A-Z a-z | tr '[:space:]' Z | \
tr -cs '[:alpha:]' Z | tr -s '\173-\377' Z | tr Z ' '`

#    'strings'    'tr'.
#  "tr A-Z a-z"  --    .
#  "tr '[:space:]'"  --     Z.
#  "tr -cs '[:alpha:]' Z"  --      Z,
#+     Z.
#  "tr -s '\173-\377' Z"  --   ,    'z'  Z
#+     Z,
#+     ,     
#+   (tr).
#  , "tr Z ' '" --    Z  ,
#+         ,  .

#          'tr',
#+         .


for word in $wlist                    # :
                                      #  $wlist     .
                                      # "$wlist" --  .
                                      # ?
do

  strlen=${#word}                     #  .
  if [ "$strlen" -lt "$MINSTRLEN" ]   #    .
  then
    continue
  fi

  grep -Fw $word "$WORDFILE"          #    .

done


exit 0
