#!/bin/bash
#     .

v0=abc1234zip1234abc    #   .
echo "v0 = $v0"         # abc1234zip1234abc
echo

#     .
v1=${v0/#abc/ABCDEF}    # abc1234zip1234abc
                        # |-|
echo "v1 = $v1"         # ABCDE1234zip1234abc
                        # |---|

#     .
v2=${v0/%abc/ABCDEF}    # abc1234zip123abc
                        #              |-|
echo "v2 = $v2"         # abc1234zip1234ABCDEF
                        #               |----|

echo

#  ----------------------------------------------------
#       / ,
#+    .
#  ----------------------------------------------------
v3=${v0/#123/000}       #  ,     .
echo "v3 = $v3"         # abc1234zip1234abc
                        #   !
v4=${v0/%123/000}       #  ,     .
echo "v4 = $v4"         # abc1234zip1234abc
                        #   !

exit 0
