#!/bin/bash
# strip-comment.sh:   (/* COMMENT */)       C.

E_NOARGS=65
E_ARGERROR=66
E_WRONG_FILE_TYPE=67

if [ $# -eq "$E_NOARGS" ]
then
  echo " : `basename $0` C-program-file" >&2 #    stderr.
  exit $E_ARGERROR
fi

#   .
type=`eval file $1 | awk '{ print $2, $3, $4, $5 }'`
# "file $1" --   ...
#  awk    --  ...
#       "type".
correct_type="ASCII C program text"

if [ "$type" != "$correct_type" ]
then
  echo
  echo "          C."
  echo
  exit $E_WRONG_FILE_TYPE
fi


#    sed :
#--------
sed '
/^\/\*/d
/.*\/\*/d
' $1
#--------
#         sed,     .


#      
#+ ,      .
#    ,   .

#  ,     ,     "*/"  "/*",
#    .

exit 0


# ----------------------------------------------------------------
# ,      -    'exit 0'.

# Stephane Chazelas  ,  :

usage() {
  echo " : `basename $0` C-program-file" >&2
  exit 1
}

WEIRD=`echo -n -e '\377'`   #  WEIRD=$'\377'
[[ $# -eq 1 ]] || usage
case `file "$1"` in
  *"C program text"*) sed -e "s%/\*%${WEIRD}%g;s%\*/%${WEIRD}%g" "$1" \
     | tr '\377\n' '\n\377' \
     | sed -ne 'p;n' \
     | tr -d '\n' | tr '\377' '\n';;
  *) usage;;
esac

#  ,       :
# printf("/*");
# 
# /*  /*    */
#
#     (\", \\" ...)    
# (    lex  yacc?).

exit 0
