#!/bin/bash

# string.bash ---    string(3)
# : Noah Friedman &lt;friedman@prep.ai.mit.edu&gt;
# ==>        .
#  : 1992-07-01
#   : 1993-09-29
# Public domain

#    bash v2  Chet Ramey

# :
# :

#:docstring strcat:
#  : strcat s1 s2
#
# Strcat    s2   s1.
#
# :
#    a="foo"
#    b="bar"
#    strcat a b
#    echo $a
#    => foobar
#
#:end docstring:

###;;;autoload
function strcat ()
{
    local s1_val s2_val

    s1_val=${!1}                        #  
    s2_val=${!2}
    eval "$1"=\'"${s1_val}${s2_val}"\'
    # ==> eval $1='${s1_val}${s2_val}'   ,
    # ==>       .
}

#:docstring strncat:
#  : strncat s1 s2 $n
#
#  strcat,     n  
#  s2.    stdout.
#
# :
#    a=foo
#    b=barbaz
#    strncat a b 3
#    echo $a
#    => foobar
#
#:end docstring:

###;;;autoload
function strncat ()
{
    local s1="$1"
    local s2="$2"
    local -i n="$3"
    local s1_val s2_val

    s1_val=${!s1}                       # ==>  
    s2_val=${!s2}

    if [ ${#s2_val} -gt ${n} ]; then
       s2_val=${s2_val:0:$n}            # ==>  
    fi

    eval "$s1"=\'"${s1_val}${s2_val}"\'
    # ==> eval $1='${s1_val}${s2_val}'   ,
    # ==>       .
}

#:docstring strcmp:
#  : strcmp $s1 $s2
#
# Strcmp       , 
#   ,     .
#:end docstring:

###;;;autoload
function strcmp ()
{
    [ "$1" = "$2" ] && return 0

    [ "${1}" '<' "${2}" ] > /dev/null && return -1

    return 1
}

#:docstring strncmp:
#  : strncmp $s1 $s2 $n
#
#  strcmp,     n 
#:end docstring:

###;;;autoload
function strncmp ()
{
    if [ -z "${3}" -o "${3}" -le "0" ]; then
       return 0
    fi

    if [ ${3} -ge ${#1} -a ${3} -ge ${#2} ]; then
       strcmp "$1" "$2"
       return $?
    else
       s1=${1:0:$3}
       s2=${2:0:$3}
       strcmp $s1 $s2
       return $?
    fi
}

#:docstring strlen:
#  : strlen s
#
#      s.
#:end docstring:

###;;;autoload
function strlen ()
{
    eval echo "\${#${1}}"
    # ==>   ,
    # ==>     .
}

#:docstring strspn:
#  : strspn $s1 $s2
#
# Strspn       s1,
#       s2.
#:end docstring:

###;;;autoload
function strspn ()
{
    #    IFS      .
    local IFS=
    local result="${1%%[!${2}]*}"

    echo ${#result}
}

#:docstring strcspn:
#  : strcspn $s1 $s2
#
# Strcspn       s1,
#        s2.
#:end docstring:

###;;;autoload
function strcspn ()
{
    #    IFS      .
    local IFS=
    local result="${1%%[${2}]*}"

    echo ${#result}
}

#:docstring strstr:
#  : strstr s1 s2
#
# Strstr      s2
#   s1,    ,   s2   s1  .
#  s2    ,  strstr   s1.
#:end docstring:

###;;;autoload
function strstr ()
{
    #  s2 --   ,    s1
    [ ${#2} -eq 0 ] && { echo "$1" ; return 0; }

    #   ,  s2    s1
    case "$1" in
    *$2*) ;;
    *) return 1;;
    esac

    #  ,      s2  s1
    first=${1/$2*/}

    #       
    echo "${1##$first}"
}

#:docstring strtok:
#  : strtok s1 s2
#
# Strtok   s1,    0,  ,
#  (),    s2
#    (   s1)
#     stdout.
#       s1    ,
#          ,
#       s1.
#    ,       stdout
#  . -      .
#:end docstring:

###;;;autoload
function strtok ()
{
 :
}

#:docstring strtrunc:
#  : strtrunc $n $s1 {$s2} {$...}
#
#   ,   strncmp,   "" .
#   n      s1 s2 ...  stdout.
#:end docstring:

###;;;autoload
function strtrunc ()
{
    n=$1 ; shift
    for z; do
        echo "${z:0:$n}"
    done
}

# provide string

# string.bash  


# ========================================================================== #
# ==> ,   ,   .

# ==>        "", 
# ==>  ,     "source"     .

# strcat
string0=one
string1=two
echo
echo "  \"strcat\" :"
echo " \"string0\" = $string0"
echo "\"string1\" = $string1"
strcat string0 string1
echo " \"string0\" = $string0"
echo

# strlen
echo
echo "   \"strlen\" :"
str=123456789
echo "\"str\" = $str"
echo -n "  \"str\" = "
strlen str
echo



# :
# ---------
#    .


exit 0
