#!/bin/bash
# stack.sh:   "" ("  --  ")

#    ,  ""      
#+ "  --  ".

BP=100            #    -.
                  #   -- 100- .

SP=$BP            #   .
                  #  --  .

Data=             #    .
                  #     ,
                  #+ -      .

declare -a stack


push()            #     .
{
if [ -z "$1" ]    #  ,     ?
then
  return
fi

let "SP -= 1"     #   .
stack[$SP]=$1

return
}

pop()                    #     .
{
Data=                    #  .

if [ "$SP" -eq "$BP" ]   #  ?
then
  return
fi                       #      SP    -- 100,

Data=${stack[$SP]}
let "SP += 1"            #   .
return
}

status_report()          #   .
{
echo "-------------------------------------"
echo ""
echo "  SP = $SP"
echo "     \""$Data"\""
echo "-------------------------------------"
echo
}


# =======================================================
#   .

echo

#   -   .
pop
status_report

echo

push garbage
pop
status_report     #  garbage,  garbage.

value1=23; push $value1
value2=skidoo; push $value2
value3=FINAL; push $value3

pop              # FINAL
status_report
pop              # skidoo
status_report
pop              # 23
status_report    #   --  !

#            push  pop.

echo
# =======================================================


# :
# -----------

# 1)    "push()"  ,
#   +           .

# 2)    "pop()"  ,
#   +           .

# 3)     ,  4  ?
#   +   .

exit 0
