#!/bin/bash
# soundex.sh:   ""

# =======================================================
#        Soundex
#            
#         Mendel Cooper
#     thegrendel@theriver.com
#       23  2002 .
#
#    : Public Domain.
#
#       
#+   (Ed Schaefer)   2002    "Shell Corner"
#+ "Unix Review" on-line,
#+ http://www.unixreview.com/documents/uni1026336632258/
# =======================================================


ARGCOUNT=1                     #    .
E_WRONGARGS=70

if [ $# -ne "$ARGCOUNT" ]
then
  echo " : `basename $0` "
  exit $E_WRONGARGS
fi


assign_value ()                #    
{                              #+   .

  val1=bfpv                    # 'b,f,p,v' = 1
  val2=cgjkqsxz                # 'c,g,j,k,q,s,x,z' = 2
  val3=dt                      #   ..
  val4=l
  val5=mn
  val6=r

#    ,   .

value=$( echo "$1" \
| tr -d wh \
| tr $val1 1 | tr $val2 2 | tr $val3 3 \
| tr $val4 4 | tr $val5 5 | tr $val6 6 \
| tr -s 123456 \
| tr -d aeiouy )

#      .
#   ,     .
#  ,     ,     .
#  'w'  'h'    .
}


input_name="$1"
echo
echo " = $input_name"


#        .
# ------------------------------------------------
name=$( echo $input_name | tr A-Z a-z )
# ------------------------------------------------


#     "":    .
# --------------------------------------------


char_pos=0                     #    .
prefix0=${name:$char_pos:1}
prefix=`echo $prefix0 | tr a-z A-Z`
                               #     --   .

let "char_pos += 1"            #  ""   .
name1=${name:$char_pos}


# ++++++++++++++++++++++++++++    +++++++++++++++++++++++++++++++
#        .
#         
#+    .
#   ,    --     
#+ , 'w'  'h'.

char1=`echo $prefix | tr A-Z a-z`    #   --   .

assign_value $name
s1=$value
assign_value $name1
s2=$value
assign_value $char1
s3=$value
s3=9$s3                              #       --  
                                     #+  'w'  'h',
                                     #+   ""  .
				     #+   9,  
				     #+  ,    .


if [[ "$s1" -ne "$s2" || "$s3" -eq 9 ]]
then
  suffix=$s2
else
  suffix=${s2:$char_pos}
fi
# ++++++++++++++++++++++++     +++++++++++++++++++++++++++++++


padding=000                    #   .


soun=$prefix$suffix$padding    #      .

MAXLEN=4                       #    4- .
soundex=${soun:0:$MAXLEN}

echo "  = $soundex"

echo

#   "" -      
#+   .
#   ""      ,
#+    3-  .
#  ,    ,    "".

#   :
#   Smith  Smythe --    "" "S530".
#   Harrison = H625
#   Hargison = H622
#   Harriman = H655

#        ,    .
#
#
#      
#+ "National Archives and Records Administration home page",
#+ http://www.nara.gov/genealogy/soundex/soundex.html



# :
# ----------
#   "  " .

exit 0
