#!/bin/bash
# seeding-random.sh:   RANDOM.

MAXCOUNT=25       #    .

random_numbers ()
{
count=0
while [ "$count" -lt "$MAXCOUNT" ]
do
  number=$RANDOM
  echo -n "$number "
  let "count += 1"
done
}

echo; echo

RANDOM=1          #       RANDOM.
random_numbers

echo; echo

RANDOM=1          #     ...
random_numbers    # ...      .
                  #
                  #         ?

echo; echo

RANDOM=2          #   ,     ...
random_numbers    #   .

echo; echo

# RANDOM=$$       PID -.
#           'time'  'date'.

#  ...
SEED=$(head -1 /dev/urandom | od -N 1 | awk '{ print $2 }')
#    
#+      /dev/urandom ,
#+       "od",
#+   "awk"      SEED.
RANDOM=$SEED
random_numbers

echo; echo

exit 0
