#!/bin/bash
# rpm-check.sh

#   rpm-,  ,    .
#    .
#
#         .

SUCCESS=0
E_NOARGS=65

if [ -z "$1" ]
then
  echo " : `basename $0` rpm-file"
  exit $E_NOARGS
fi

{
  echo
  echo " :"
  rpm -qpi $1       #  .
  echo
  echo " :"
  rpm -qpl $1       #  .
  echo
  rpm -i --test $1  #   .
  if [ "$?" -eq $SUCCESS ]
  then
    echo "$1   ."
  else
    echo "$1 --  !"
  fi
  echo
} > "$1.test"       #    .

echo "  rpm-    $1.test"

#       rpm . man rpm.

exit 0
