#!/bin/bash
# ramdisk.sh

#  " " --     
#+        .
#    --    /.
#   -- ,   ,  ,
#                  .
#
#     ?
#     ,       ,   
#+        ,     
#        .


E_NON_ROOT_USER=70             #      root.
ROOTUSER_NAME=root

MOUNTPT=/mnt/ramdisk
SIZE=2000                      # 2K  (,   )
BLOCKSIZE=1024                 #   -- 1K (1024 )
DEVICE=/dev/ram0               #   ram

username=`id -nu`
if [ "$username" != "$ROOTUSER_NAME" ]
then
  echo "     root."
  exit $E_NON_ROOT_USER
fi

if [ ! -d "$MOUNTPT" ]         #     ,
then                           #+   ,    
  mkdir $MOUNTPT               #+    .
fi

dd if=/dev/zero of=$DEVICE count=$SIZE bs=$BLOCKSIZE  #   .
mke2fs $DEVICE                 #    ext2.
mount $DEVICE $MOUNTPT         # .
chmod 777 $MOUNTPT             #       .
                               #   ,  root   .

echo "  \"$MOUNTPT\"   ."
#         .

#  !   --   !  ,   ,
#+       .
#        ,       .

#  ,     ,   .
#   /mnt/ramdisk,    ,   .

exit 0
