#!/bin/bash

#  "Q-"   *Douglas Hofstadter):

# Q(1) = Q(2) = 1
# Q(n) = Q(n - Q(n-1)) + Q(n - Q(n-2)),  n&gt;2

#  ""      .
#  20  :
# 1 1 2 3 3 4 5 5 6 6 6 8 8 8 10 9 10 11 11 12

# .   , "Goedel, Escher, Bach: An Eternal Golden Braid",
# p. 137, ff.


LIMIT=100     #   100  
LINEWIDTH=20  #   ,      

Q[1]=1        #      1.
Q[2]=1

echo
echo "Q- [ $LIMIT ]:"
echo -n "${Q[1]} "             #     .
echo -n "${Q[2]} "

for ((n=3; n <= $LIMIT; n++))  # C-  .
do   # Q[n] = Q[n - Q[n-1]] + Q[n - Q[n-2]]   n&gt;2
#       ,
#  Bash          .

  let "n1 = $n - 1"        # n-1
  let "n2 = $n - 2"        # n-2

  t0=`expr $n - ${Q[n1]}`  # n - Q[n-1]
  t1=`expr $n - ${Q[n2]}`  # n - Q[n-2]

  T0=${Q[t0]}              # Q[n - Q[n-1]]
  T1=${Q[t1]}              # Q[n - Q[n-2]]

Q[n]=`expr $T0 + $T1`      # Q[n - Q[n-1]] + Q[n - Q[n-2]]
echo -n "${Q[n]} "

if [ `expr $n % $LINEWIDTH` -eq 0 ]    #    20   .
then   # 
  echo #    .
fi

done

echo

exit 0

#        Q-.
#  ,    ,  ,   .
# :       **  .
