#!/bin/bash
# pid-identifier.sh:           (pid).

ARGNO=1  # ,    , .
E_WRONGARGS=65
E_BADPID=66
E_NOSUCHPROCESS=67
E_NOPERMISSION=68
PROCFILE=exe

if [ $# -ne $ARGNO ]
then
  echo " : `basename $0` PID-" >&2  #     >stderr.
  exit $E_WRONGARGS
fi

ps ax

pidno=$( ps ax | grep $1 | awk '{ print $1 }' | grep $1 )
#      pid  ,    "ps",  #1.
#   ,         ('ps').
#    "grep $1".
if [ -z "$pidno" ]  #      ,
then                #   ,        pid.
  echo "  ."
  exit $E_NOSUCHPROCESS
fi

#  :
#   if ! ps $1 > /dev/null 2>&1
#   then                #       pid.
#     echo "  ."
#     exit $E_NOSUCHPROCESS
#    fi


if [ ! -r "/proc/$1/$PROCFILE" ]  #    .
then
  echo " $1 , ..."
  echo "       /proc/$1/$PROCFILE."
  exit $E_NOPERMISSION  #     
                        #        /proc.
fi

#       :
#    if ! kill -0 $1 > /dev/null 2>&1 # '0' --   , 
                                      #     
                                      # -.
#    then echo "   PID  ,      " >&2
#    exit $E_BADPID
#    fi



exe_file=$( ls -l /proc/$1 | grep "exe" | awk '{ print $11 }' )
#       exe_file=$( ls -l /proc/$1/exe | awk '{print $11}' )
#
# /proc/pid-number/exe --   
#     .

if [ -e "$exe_file" ]  #   /proc/pid-number/exe ...
then                 #     .
  echo "   #$1: $exe_file."
else
  echo "  ."
fi


#   , ,   ,    
# ps ax | grep $1 | awk '{ print $5 }'
#  ,   ...
#    ,  'ps',  argv[0] ,
#      .
#
# ,      .
#       find /proc/$1/exe -printf '%l\n'
#       lsof -aFn -p $1 -d txt | sed -ne 's/^n//p'

#   : Stephane Chazelas.

exit 0
