#!/bin/bash
#        # ## % %%.

var1=abcd12345abc6789
pattern1=a*c  # * ( ),     a  c.

echo
echo "var1 = $var1"           # abcd12345abc6789
echo "var1 = ${var1}"         # abcd12345abc6789   ( )
echo "   ${var1} = ${#var1}"
echo "pattern1 = $pattern1"   # a*c  ( 'a'  'c'    )
echo


echo '${var1#$pattern1}  =' "${var1#$pattern1}"    #         d12345abc6789
#  ,   3   abcd12345abc6789
                                  ^^^^^^            |-|
echo '${var1##$pattern1} =' "${var1##$pattern1}"   #                  6789
#  ,   12  abcd12345abc6789
#                                 ^^^^^^             |----------|

echo; echo

pattern2=b*9            # ,   'b'  '9'
echo "var1 = $var1"     # abcd12345abc6789
echo "pattern2 = $pattern2"
echo

echo '${var1%pattern2}  =' "${var1%$pattern2}"     #     abcd12345a
#  ,   6   abcd12345abc6789
#                                 ^^^^^^^^^                       |----|
echo '${var1%%pattern2} =' "${var1%%$pattern2}"    #     a
#  ,   12   abcd12345abc6789
#                                 ^^^^^^^^^               |-------------|

# , #  ##      ,
#            %  %%      .

echo

exit 0
