#!/bin/bash
# numbers.sh:    .

# : -
let "dec = 32"
echo "  = $dec"             # 32
# -  .


# :    '0' ()
let "oct = 032"
echo "  = $oct"           # 26
#     .
# --------- ------ -- -------

# :    '0x'  '0X'
let "hex = 0x32"
echo "  = $hex"      # 50
#     .

#   : #
#     2  64.
#         ,
# . .

let "bin = 2#111100111001101"
echo "  = $bin"               # 31181

let "b32 = 32#77"
echo "32-  = $b32"              # 231

let "b64 = 64#@_"
echo "64-  = $b64"              # 4094
#
#   #    
#+    ( 2  64)
#  10  + 26     + 26     + @ + _

echo

echo $((36#zz)) $((2#10101010)) $((16#AF16)) $((53#1aA))
                                         # 1295 170 44822 3375


#   :
#  --------------
#   ,   ,   ,
#+   
#+       .

let "bad_oct = 081"
# numbers.sh: let: oct = 081: value too great for base (error token is "081")
#                       
#+                     0 - 7.

exit 0       #  Rich Bartell  Stephane Chazelas,  .
