#!/bin/bash
# logevents.sh, : Stephane Chazelas.

#    .
#      root (       /var/log).

ROOT_UID=0     #  root     $UID = 0.
E_NOTROOT=67   #  ,   root.


if [ "$UID" -ne "$ROOT_UID" ]
then
  echo "     root."
  exit $E_NOTROOT
fi


FD_DEBUG1=3
FD_DEBUG2=4
FD_DEBUG3=5

#     , ,   .
# LOG_EVENTS=1
# LOG_VARS=1


log()  #      .
{
echo "$(date)  $*" &gt;&7     #    .
                              # . .
}



case $LOG_LEVEL in
 1) exec 3&gt;&2         4&gt; /dev/null 5&gt; /dev/null;;
 2) exec 3&gt;&2         4&gt;&2         5&gt; /dev/null;;
 3) exec 3&gt;&2         4&gt;&2         5&gt;&2;;
 *) exec 3&gt; /dev/null 4&gt; /dev/null 5&gt; /dev/null;;
esac

FD_LOGVARS=6
if [[ $LOG_VARS ]]
then exec 6&gt;&gt; /var/log/vars.log
else exec 6&gt; /dev/null               #  .
fi

FD_LOGEVENTS=7
if [[ $LOG_EVENTS ]]
then
  # then exec 7 &gt;(exec gawk '{print strftime(), $0}' &gt;&gt; /var/log/event.log)
  # , ,    Bash,  2.04.
  exec 7&gt;&gt; /var/log/event.log        #    "event.log".
  log                                      #    .
else exec 7&gt; /dev/null                  #  .
fi

echo "DEBUG3: beginning" &gt;&${FD_DEBUG3}

ls -l &gt;&5 2&gt;&4                       # command1 &gt;&5 2&gt;&4

echo "Done"                                # command2

echo "sending mail" &gt;&${FD_LOGEVENTS}   #  "sending mail"  . #7.


exit 0
