#!/bin/bash
# isalpha.sh:  "case"   .

SUCCESS=0
FAILURE=-1

isalpha ()  #  -       .
{
if [ -z "$1" ]                #     ?
then
  return $FAILURE
fi

case "$1" in
[a-zA-Z]*) return $SUCCESS;;  #   - ?
*        ) return $FAILURE;;
esac
}             #    "isalpha ()"   C.


isalpha2 ()   #  -        .
{
  [ $# -eq 1 ] || return $FAILURE

  case $1 in
  *[!a-zA-Z]*|"") return $FAILURE;;
               *) return $SUCCESS;;
  esac
}

isdigit ()    #  -       .
{             #   -     .
  [ $# -eq 1 ] || return $FAILURE

  case $1 in
  *[!0-9]*|"") return $FAILURE;;
            *) return $SUCCESS;;
  esac
}



check_var ()  #   isalpha
{
if isalpha "$@"
then
  echo "\"$*\"    ."
  if isalpha2 "$@"
  then        #     ,     .
    echo "\"$*\"    ."
  else
    echo "\"$*\"        ."
  fi
else
  echo "\"$*\"      ."
              #       ,
              #+  ,    " " .
fi

echo

}

digit_check ()  #   isdigit ().
{
if isdigit "$@"
then
  echo "\"$*\"    [0 - 9]."
else
  echo "\"$*\"        ."
fi

echo

}

a=23skidoo
b=H3llo
c=-What?
d=What?
e=`echo $b`   #  .
f=AbcDef
g=27234
h=27a34
i=27.34

check_var $a
check_var $b
check_var $c
check_var $d
check_var $e
check_var $f
check_var     #   ,  ?
#
digit_check $g
digit_check $h
digit_check $i


exit 0        #   S.C.

# :
# --------
#    'isfloat ()',     .
#  :     'isdigit ()',
#+       .
