#!/bin/bash
# idelete.sh:     inode.

#       ,       ,
#+ , ?  -.

ARGCOUNT=1                      #       .
E_WRONGARGS=70
E_FILE_NOT_EXIST=71
E_CHANGED_MIND=72

if [ $# -ne "$ARGCOUNT" ]
then
  echo " : `basename $0` filename"
  exit $E_WRONGARGS
fi

if [ ! -e "$1" ]
then
  echo " \""$1"\"  ."
  exit $E_FILE_NOT_EXIST
fi

inum=`ls -i | grep "$1" | awk '{print $1}'`
# inum =  inode (index node) 
#     inode,       .

echo; echo -n "    ,    \"$1\" (y/n)? "
#  '-v'   'rm'      .
read answer
case "$answer" in
[nN]) echo "?"
      exit $E_CHANGED_MIND
      ;;
*)    echo "  \"$1\".";;
esac

find . -inum $inum -exec rm {} \;
echo " "\"$1"\" !"

exit 0
