#!/bin/bash
# gcd.sh:    
#           

#   "  " ()   
#+    ,      .

#      .
#    ,
#+   &lt;---  
#+  &lt;---  
#+   ,       ( = 0).
#+ The gcd = dividend, on the final pass.
#
#       
#    Jim Loy, http://www.jimloy.com/number/euclids.htm.


# ------------------------------------------------------
#   
ARGS=2
E_BADARGS=65

if [ $# -ne "$ARGS" ]
then
  echo " : `basename $0` - -"
  exit $E_BADARGS
fi
# ------------------------------------------------------


gcd ()
{

                                 #   .
  dividend=$1                    #   ,   
  divisor=$2                     #+    .
                                 #  ?

  remainder=1                    #    ,
                                 #+       
                                 #+    .

  until [ "$remainder" -eq 0 ]
  do
    let "remainder = $dividend % $divisor"
    dividend=$divisor            #      
    divisor=$remainder
  done                           #  

}                                #  $dividend   .


gcd $1 $2

echo; echo "  $1  $2 = $dividend"; echo


#  :
# --------
#      ,
#+         , 
#+      .

exit 0
