#! /bin/sh
# $Id: ftpget,v 1.2 91/05/07 21:15:43 moraes Exp $
#      ftp-.
#    -     ftplist
# -h --   (- prep.ai.mit.edu)
# -d --    -        -d
#     ,
#     .
# (- --   ftp)
# -v -- "" ,     ftp-
# -f -- file[:localfile]   file     localfile
# -m --   mget.     !
# -c --  
# ,
# 	ftpget -h expo.lcs.mit.edu -d contrib -f xplaces.shar:xplaces.sh \
#		-d ../pub/R3/fixes -c ~/fixes -m 'fix*'
#     xplaces.shar  ~ftp/contrib  expo.lcs.mit.edu
#     xplaces.sh   ,     (fixes)
#  ~ftp/pub/R3/fixes      ~/fixes.
# ,       , 
#    ,    ftp-
#
# Mark Moraes (moraes@csri.toronto.edu), Feb 1, 1989
#


# ==>     .

# PATH=/local/bin:/usr/ucb:/usr/bin:/bin
# export PATH
# ==>        .

TMPFILE=/tmp/ftp.$$
# ==>   

SITE=`domainname`.toronto.edu
# ==> 'domainname'  'hostname'

usage=" : $0 [-h _] [-d _]... [-f _:_]... \
		[-c _] [-m __] [-v]"
ftpflags="-i -n"
verbflag=
set -f 		#     (globbing)   -m
set x `getopt vh:d:c:m:f: $*`
if [ $? != 0 ]; then
	echo $usage
	exit 65
fi
shift
trap 'rm -f ${TMPFILE} ; exit' 0 1 2 3 15
echo "user anonymous ${USER-gnu}@${SITE} > ${TMPFILE}"
# ==>   ().
echo binary >> ${TMPFILE}
for i in $*   # ==>   .
do
	case $i in
	-v) verbflag=-v; echo hash >> ${TMPFILE}; shift;;
	-h) remhost=$2; shift 2;;
	-d) echo cd $2 >> ${TMPFILE};
	    if [ x${verbflag} != x ]; then
	        echo pwd >> ${TMPFILE};
	    fi;
	    shift 2;;
	-c) echo lcd $2 >> ${TMPFILE}; shift 2;;
	-m) echo mget "$2" >> ${TMPFILE}; shift 2;;
	-f) f1=`expr "$2" : "\([^:]*\).*"`; f2=`expr "$2" : "[^:]*:\(.*\)"`;
	    echo get ${f1} ${f2} >> ${TMPFILE}; shift 2;;
	--) shift; break;;
	esac
done
if [ $# -ne 0 ]; then
	echo $usage
	exit 65   # ==>    "exit 2",     .
fi
if [ x${verbflag} != x ]; then
	ftpflags="${ftpflags} -v"
fi
if [ x${remhost} = x ]; then
	remhost=prep.ai.mit.edu
	# ==>     ftp- -.
fi
echo quit >> ${TMPFILE}
# ==>      .

ftp ${ftpflags} ${remhost} < ${TMPFILE}
# ==>    .

rm -f ${TMPFILE}
# ==>  ,    (     ).


# ==> :
# ==> ----------
# ==> 1)   .
# ==> 2)    .
