#!/bin/bash
# file-integrity.sh:      

E_DIR_NOMATCH=70
E_BAD_DBFILE=71

dbfile=File_record.md5
#     .


set_up_database ()
{
  echo ""$directory"" > "$dbfile"
  #       .
  md5sum "$directory"/* >> "$dbfile"
  #    md5   .
}

check_database ()
{
  local n=0
  local filename
  local checksum

  # ------------------------------------------- #
  #       ,
  #+    ,     .

  if [ ! -r "$dbfile" ]
  then
    echo "      !"
    exit $E_BAD_DBFILE
  fi
  # ------------------------------------------- #

  while read record[n]
  do

    directory_checked="${record[0]}"
    if [ "$directory_checked" != "$directory" ]
    then
      echo "       !"
      #        .
      exit $E_DIR_NOMATCH
    fi

    if [ "$n" -gt 0 ]   #   .
    then
      filename[n]=$( echo ${record[$n]} | awk '{ print $2 }' )
      #  md5sum    ,
      #+   ,   .
      checksum[n]=$( md5sum "${filename[n]}" )

      if [ "${record[n]}" = "${checksum[n]}" ]
      then
        echo " ${filename[n]}   ."
      else
        echo "     ${filename[n]}!"
        #       .
      fi

    fi


    let "n+=1"
  done <"$dbfile"       #     .

}

# =================================================== #
# main ()

if [ -z  "$1" ]
then
  directory="$PWD"      #     ,
else                    #+    .
  directory="$1"
fi

clear                   #  .

# ------------------------------------------------------------------ #
  if [ ! -r "$dbfile" ] #      ?
  then
    echo "    , \""$directory"/"$dbfile"\"."; echo
    set_up_database
  fi
# ------------------------------------------------------------------ #

check_database          #  .

echo

#        ,
#+        .

#      ,
#+       "Tripwire",
#+ http://sourceforge.net/projects/tripwire/.

exit 0
