#!/bin/bash

#   .
#       root.

ROOT_UID=0         #  root -- $UID 0.
E_WRONG_USER=65    #  root?

FILE=/swap
BLOCKSIZE=1024
MINBLOCKS=40
SUCCESS=0

if [ "$UID" -ne "$ROOT_UID" ]
then
  echo; echo "      root."; echo
  exit $E_WRONG_USER
fi


blocks=${1:-$MINBLOCKS}          #  - -- 40 ,
                                 #+       .
#     .
# --------------------------------------------------
# if [ -n "$1" ]
# then
#   blocks=$1
# else
#   blocks=$MINBLOCKS
# fi
# --------------------------------------------------


if [ "$blocks" -lt $MINBLOCKS ]
then
  blocks=$MINBLOCKS              #     40 .
fi


echo "    $blocks  (KB)."
dd if=/dev/zero of=$FILE bs=$BLOCKSIZE count=$blocks  # "" .

mkswap $FILE $blocks             #    .
swapon $FILE                     # .

echo "    ."

exit $SUCCESS
