#!/bin/bash
# sieve.sh

#  
#      .

#       
#     C.

LOWER_LIMIT=1       #   1.
UPPER_LIMIT=1000    #  1000.
# (      ...       .)

PRIME=1
NON_PRIME=0

declare -a Primes
# Primes[] -- .


initialize ()
{
#  .

i=$LOWER_LIMIT
until [ "$i" -gt "$UPPER_LIMIT" ]
do
  Primes[i]=$PRIME
  let "i += 1"
done
#       ,
#    .
}

print_primes ()
{
#     Primes[],   .

i=$LOWER_LIMIT

until [ "$i" -gt "$UPPER_LIMIT" ]
do

  if [ "${Primes[i]}" -eq "$PRIME" ]
  then
    printf "%8d" $i
    # 8         .
  fi

  let "i += 1"

done

}

sift () #   .
{

let i=$LOWER_LIMIT+1
#  ,  1 --   ,    2.

until [ "$i" -gt "$UPPER_LIMIT" ]
do

if [ "${Primes[i]}" -eq "$PRIME" ]
#     ,    .
then

  t=$i

  while [ "$t" -le "$UPPER_LIMIT" ]
  do
    let "t += $i "
    Primes[t]=$NON_PRIME
    #  ,    $t  ,   .
  done

fi

  let "i += 1"
done


}


#  .
initialize
sift
print_primes
#    .

echo

exit 0



# ----------------------------------------------- #
# ,  ,   -  exit,  .

#  ,  Stephane Chazelas,
#   .

#      ,   .

UPPER_LIMIT=$1                  #   .
let SPLIT=UPPER_LIMIT/2         #      .

Primes=( '' $(seq $UPPER_LIMIT) )

i=1
until (( ( i += 1 ) > SPLIT ))  #        .
do
  if [[ -n $Primes[i] ]]
  then
    t=$i
    until (( ( t += i ) > UPPER_LIMIT ))
    do
      Primes[t]=
    done
  fi
done
echo ${Primes[*]}

exit 0
