#!/bin/bash

#               
#               ---------


#   bash  ?
# ! ...
#    ,     
#    .


MAX_ARG=5
E_WRONG_ARGS=65
E_RANGE_ERR=66


if [ -z "$1" ]
then
  echo " : `basename $0` "
  exit $E_WRONG_ARGS
fi

if [ "$1" -gt $MAX_ARG ]
then
  echo "    (   -- 5)."
  #   .
  #      ,
  #        .
  exit $E_RANGE_ERR
fi

fact ()
{
  local number=$1
  #  "number"     ,
  #    .
  if [ "$number" -eq 0 ]
  then
    factorial=1    #   0 = 1.
  else
    let "decrnum = number - 1"
    fact $decrnum  #   .
    let "factorial = $number * $?"
  fi

  return $factorial
}

fact $1
echo "  $1 = $?."

exit 0
