#!/bin/bash

#       'expr'
# =======================================

echo

#  
# -------------- --------

echo " "
echo
a=`expr 5 + 3`
echo "5 + 3 = $a"

a=`expr $a + 1`
echo
echo "a + 1 = $a"
echo "( )"

a=`expr 5 % 3`
#    (  )
echo
echo "5 mod 3 = $a"

echo
echo

#  
# ---------- --------

#   1   , 0 --  ,
#+   ,   Bash.

echo " "
echo

x=24
y=25
b=`expr $x = $y`         # .
echo "b = $b"            # 0  ( $x -ne $y )
echo

a=3
b=`expr $a \> 10`
echo 'b=`expr $a \> 10`, ...'
echo " a > 10,  b = 0 ()"
echo "b = $b"            # 0  ( 3 ! -gt 10 )
echo

b=`expr $a \< 10`
echo " a < 10,  b = 1 ()"
echo "b = $b"            # 1  ( 3 -lt 10 )
echo
#      .

b=`expr $a \<= 3`
echo " a <= 3,  b = 1 ()"
echo "b = $b"            # 1  ( 3 -le 3 )
#    "\>=" (  ).


echo
echo

#  
# -------- ---------

echo " "
echo
a=zipper
echo "a is $a"
if [ `expr $a = snap` ]
then
   echo "a --   zipper"
fi

echo
echo



#   
# -------- -- --------

echo "  "
echo

a=1234zipper43231
echo "    : \"$a\"."

# length:  
b=`expr length $a`
echo "  \"$a\"  $b."

# index:      
b=`expr index $a 23`
echo "   \"2\"   \"$a\" : \"$b\"."

# substr:  ,    ,  
b=`expr substr $a 2 6`
echo "   \"$a\",    2,\
   6 : \"$b\"."


#      , - 
#+   ****** .
#
#          
b=`expr match "$a" '[0-9]*'`               #    .
echo      \"$a\" : $b.
b=`expr match "$a" '\([0-9]*\)'`           #       
#                   ==      ==
echo ",     \"$a\" : \"$b\"."

echo

exit 0
