#!/bin/bash
# burn-cd.sh
# ,    CDR.


SPEED=2          #   ""      --    
IMAGEFILE=cdimage.iso
CONTENTSFILE=contents
DEFAULTDIR=/opt  #     ,     CD.
                 #   .

#   "cdrecord"  Joerg Schilling.
# (http://www.fokus.gmd.de/nthp/employees/schilling/cdrecord.html)

#          ,
#+     suid  cdrecord
#+ (chmod u+s /usr/bin/cdrecord,      root-).

if [ -z "$1" ]
then
  IMAGE_DIRECTORY=$DEFAULTDIR
  #  -,        .
else
    IMAGE_DIRECTORY=$1
fi

#   "table of contents".
ls -lRF $IMAGE_DIRECTORY > $IMAGE_DIRECTORY/$CONTENTSFILE
#  "l" -- ""    .
#  "R" --    .
#  "F" --       (      /).
echo " ."

#  iso-.
mkisofs -r -o $IMAGFILE $IMAGE_DIRECTORY
echo " iso-   ISO9660 ($IMAGEFILE)."

# "" CDR.
cdrecord -v -isosize speed=$SPEED dev=0,0 $IMAGEFILE
echo " ."
echo " ,     ."

exit 0
