#!/bin/bash
# ex33a.sh

#      .
#   sh ex33a -a
#   sh ex33a -abc
#   sh ex33a -a -b -c
#   sh ex33a -d
#   sh ex33a -dXYZ
#   sh ex33a -d XYZ
#   sh ex33a -abcd
#   sh ex33a -abcdZ
#   sh ex33a -z
#   sh ex33a a
#   .

E_OPTERR=65

if [ "$#" -eq 0 ]
then   #      .
  echo " : $0 -[options a,b,c]"
  exit $E_OPTERR
fi

set -- `getopt "abcd:" "$@"`
#       .
#  ,   "$@"  "$*"?

while [ ! -z "$1" ]
do
  case "$1" in
    -a) echo " \"a\"";;
    -b) echo " \"b\"";;
    -c) echo " \"c\"";;
    -d) echo " \"d\" $2";;
     *) break;;
  esac

  shift
done

#   'getopt'     'getopts',
#  . "ex33.sh".

exit 0
