#!/bin/bash
# ex33.sh

#       'getopts'.

#     :
# 'scriptname -mn'
# 'scriptname -oq qOption' (qOption     .)
# 'scriptname -qXXX -r'
#
# 'scriptname -qr'    -  : "r"       "q"
# 'scriptname -q -r'  -   ,   
#       ("flag:"),   
#    ,       .

NO_ARGS=0
E_OPTERROR=65

if [ $# -eq "$NO_ARGS" ]  #    ?
then
  echo " : `basename $0` options (-mnopqrs)"
  exit $E_OPTERROR        #    --   
                          #    
fi
#  : scriptname -options
#  :  (-) 


while getopts ":mnopq:rs" Option
do
echo $OPTIND
  case $Option in
    m     ) echo " #1:  -m-";;
    n | o ) echo " #2:  -$Option-";;
    p     ) echo " #3:  -p-";;
    q     ) echo " #4:  -q-,   \"$OPTARG\"";;
    #  :   'q'    ,
    #      "-".
    r | s ) echo " #5:  -$Option-"'';;
    *     ) echo "  .";;   # -
  esac
done
shift $(($OPTIND - 1))
#      .

exit 0
