#!/bin/bash
# empty-array.sh

#     Stephane Chazelas   ,
#+  Michael Zick   .


#   --     ,     .

array0=(    )
array1=( '' )   # "array1"    .
array2=( )      #  "array2"     , .. .

echo
ListArray()
{
echo
echo "  array0:  ${array0[@]}"
echo "  array1:  ${array1[@]}"
echo "  array2:  ${array2[@]}"
echo
echo "    array0 = ${#array0}"
echo "    array1 = ${#array1}"
echo "    array2 = ${#array2}"
echo
echo "    array0 = ${#array0[*]}"  # 3
echo "    array1 = ${#array1[*]}"  # 1  (!)
echo "    array2 = ${#array2[*]}"  # 0
}

# ===================================================================

ListArray

#      

#     .
array0=( "${array0[@]}" "1" )
array1=( "${array1[@]}" "1" )
array2=( "${array2[@]}" "1" )

ListArray

# 
array0[${#array0[*]}]="2"
array1[${#array1[*]}]="2"
array2[${#array2[*]}]="2"

ListArray

#      '' ('stack')
#  ,    'push' --      
# '' :
height=${#array2[@]}
echo
echo "  array2 = $height"

#  'pop' --   ,   :
unset array2[${#array2[@]}-1]	#     
height=${#array2[@]}
echo
echo "POP"
echo "  array2,   = $height"

ListArray

#   2-  3-   array0
from=1		#     
to=2		  #
declare -a array3=( ${array0[@]:1:2} )
echo
echo "  array3:  ${array3[@]}"

#    
declare -a array4=( ${array0[@]//2-} )
echo
echo "  array4:  ${array4[@]}"

#    
declare -a array5=( ${array0[@]//?/} )
echo
echo "  array5:  ${array5[@]}"

#      ...
declare -a array6=( ${array0[@]#*} )
echo #     
echo "  array6:  ${array6[@]}"

declare -a array7=( ${array0[@]#1} )
echo #       
echo "  array7:  ${array7[@]}"

#      ...
declare -a array8=( ${array0[@]/1/} )
echo
echo "  array8:  ${array8[@]}"

#  ,       ?

#     ,   
#+   var[@].
#   , BASH   
#        , 
#+   "".

#  :      ""  "" ?

zap='*'
declare -a array9=( ${array0[@]/$zap/} )
echo
echo "  array9:  ${array9[@]}"

# "...   : "  !"..."
declare -a array10=( ${array0[@]#$zap} )
echo
echo "  array10:  ${array10[@]}"

#   array7  array10
#   array8  array9

# :  "" .

exit 0
