#!/bin/bash
# days-between.sh:         .
#  : ./days-between.sh [M]M/[D]D/YYYY [M]M/[D]D/YYYY

ARGS=2                #      .
E_PARAM_ERR=65        #     .

REFYR=1600            #  .
CENTURY=100
DIY=365
ADJ_DIY=367           #     + 1.
MIY=12
DIM=31
LEAPCYCLE=4

MAXRETVAL=255         #    
                      #   .

diff=		              #    .
value=                #  .
day=                  # , , .
month=
year=


Param_Error ()        #     .
{
  echo " : `basename $0` [M]M/[D]D/YYYY [M]M/[D]D/YYYY"
  echo "       (    1/3/1600)"
  exit $E_PARAM_ERR
}


Parse_Date ()                 #  .
{
  month=${1%%/**}
  dm=${1%/**}                 #   .
  day=${dm#*/}
  let "year = `basename $1`"  #      ,    .
}


check_date ()                 #  .
{
  [ "$day" -gt "$DIM" ] || [ "$month" -gt "$MIY" ] || [ "$year" -lt "$REFYR" ] && Param_Error
  #      .
  #   "- / -".
  #
  # :     .
}


strip_leading_zero () #   
{
  val=${1#0}          #  Bash   
  return $val         #  (POSIX.2, sect 2.9.2.1).
}


day_index ()          #  :
{                     #    3 . 1600   .

  day=$1
  month=$2
  year=$3

  let "month = $month - 2"
  if [ "$month" -le 0 ]
  then
    let "month += 12"
    let "year -= 1"
  fi

  let "year -= $REFYR"
  let "indexyr = $year / $CENTURY"


  let "Days = $DIY*$year + $year/$LEAPCYCLE - $indexyr + $indexyr/$LEAPCYCLE + $ADJ_DIY*$month/$MIY + $day - $DIM"
  #       
  # http://home.t-online.de/home/berndt.schwerdtfeger/cal.htm


  if [ "$Days" -gt "$MAXRETVAL" ]  #   255,
  then                             #   
    let "dindex = 0 - $Days"       #      .
  else let "dindex = $Days"
  fi

  return $dindex

}


calculate_difference ()            #    .
{
  let "diff = $1 - $2"             #  .
}


abs ()                             #  
{                                  #    "value".
  if [ "$1" -lt 0 ]                #   
  then                             # 
    let "value = 0 - $1"           #  ,
  else                             # 
    let "value = $1"               #   .
  fi
}



if [ $# -ne "$ARGS" ]              #     .
then
  Param_Error
fi

Parse_Date $1
check_date $day $month $year      #  .

strip_leading_zero $day           #   
day=$?                            #    / .
strip_leading_zero $month
month=$?

day_index $day $month $year
date1=$?

abs $date1                         #  
date1=$value

Parse_Date $2
check_date $day $month $year

strip_leading_zero $day
day=$?
strip_leading_zero $month
month=$?

day_index $day $month $year
date2=$?

abs $date2                         #  
date2=$value

calculate_difference $date1 $date2

abs $diff                          #  
diff=$value

echo $diff

exit 0
#         C
# http://buschencrew.hypermart.net/software/datedif
