#!/bin/bash
# copy-cd.sh: copying a data CD

CDROM=/dev/cdrom                           #  CD ROM
OF=/home/bozo/projects/cdimage.iso         #  
#       /xxxx/xxxxxxx/                        .
BLOCKSIZE=2048
SPEED=2                                    #     ,  .

echo; echo "  CD,  **  ."
echo " ENTER,   . "
read ready                                 # .

echo; echo "   $OF."
echo "   - .  ."

dd if=$CDROM of=$OF bs=$BLOCKSIZE          # .


echo; echo "  CD."
echo "   CDR."
echo " ENTER,   . "
read ready                                 # .

echo "  $OF  ."

cdrecord -v -isosize speed=$SPEED dev=0,0 $OF
#   Joerg Schilling -- "cdrecord" .
# http://www.fokus.gmd.de/nthp/employees/schilling/cdrecord.html


echo; echo " ."

echo "    (y/n)? "  #    .
read answer

case "$answer" in
[yY]) rm -f $OF
      echo " $OF ."
      ;;
*)    echo " $OF   .";;
esac

echo

# :
#    "case"  ,  , "yes"  "Yes".

exit 0
