#!/bin/bash
# color-echo.sh:   .

black='\E[30;47m'
red='\E[31;47m'
green='\E[32;47m'
yellow='\E[33;47m'
blue='\E[34;47m'
magenta='\E[35;47m'
cyan='\E[36;47m'
white='\E[37;47m'


cecho ()                     # Color-echo.
                             #  $1 =  
                             #  $2 = 
{
local default_msg=" ."
                             #     .

message=${1:-$default_msg}   #   -.
color=${2:-$black}           #  - .

  echo -e "$color"
  echo "$message"
  tput sgr0                  #    .
  return
}


#  - .
# ----------------------------------------------------
cecho " ..." $blue
cecho " ." $magenta
cecho "  ." $green
cecho "  ?" $red
cecho ",      ." $cyan
cecho "   (- )."
       #  $color .
cecho "\"\"  (- )." ""
       #  ""  .
cecho
       #      .
cecho "" ""
       #   ""  $message  $color.
# ----------------------------------------------------

echo

exit 0

# :
# ---------
# 1)    'cecho ()'   " ".
# 2)     .
