#!/bin/bash
# collatz.sh

#      (Collatz) ( ).
#  -------------------------------------------
#  1)     ""  .
#  2)  &lt;---  
#  3)  .
#  4)    ,   2,
#  5)+    --   3   1.
#  6)  &lt;--- 
#  7) ,   . 3,   .
#
#  ,    ,
#+      ,
#+    "4,2,1...",
#+       .


MAX_ITERATIONS=200
#     (&gt;32000),    .

h=${1:-$$}                      #   
                                #        ,   $PID,

echo
echo "C($h) --- $MAX_ITERATIONS "
echo

for ((i=1; i<=MAX_ITERATIONS; i++))
do

echo -n "$h	"
#          ^^^^^
#           

  let "remainder = h % 2"
  if [ "$remainder" -eq 0 ]   # ?
  then
    let "h /= 2"              #   2.
  else
    let "h = h*3 + 1"         #   3   1.
  fi


COLUMNS=10                    #   10   .
let "line_break = i % $COLUMNS"
if [ "$line_break" -eq 0 ]
then
  echo
fi

done

echo

exit 0
