#!/bin/bash
# cannon.sh:   "".

#       "Monte Carlo",
#+     ,
#+       .

#  ,           10000 .
#    ,  ,    ,
#+    10000 .
#  ..     ,   .
#  ( --     .)
#
#            
#     -    ,
#+ ..   ,   ,   .
#       ,
#+       .
#         .
#
#           ,
#+            
#+  PI/4.
#
#     ,     
#+     .
#  (    .)
#
#  ,     ,    .
#  ,     ,      ,
#+       ,   .
#   ,     .


DIMENSION=10000  #     .
                 #   --      .

MAXSHOTS=1000    #  .
                 # 10000  ( )   ,
								 #     .
PMULTIPLIER=4.0  #  .

get_random ()
{
SEED=$(head -1 /dev/urandom | od -N 1 | awk '{ print $2 }')
RANDOM=$SEED                                  #    "seeding-random.sh"

let "rnum = $RANDOM % $DIMENSION"             #      10000.
echo $rnum
}

distance=        #   .
hypotenuse ()    #    .
{                #   "alt-bc.sh".
distance=$(bc -l << EOF
scale = 0
sqrt ( $1 * $1 + $2 * $2 )
EOF
)
#   "scale"       "",
#+      ,   .
#  ,  ,   .
}


# main() {

#  .
shots=0
splashes=0
thuds=0
Pi=0

while [ "$shots" -lt  "$MAXSHOTS" ]           #  .
do

  xCoord=$(get_random)                        #    X  Y.
  yCoord=$(get_random)
  hypotenuse $xCoord $yCoord                  #   = .
  ((shots++))

  printf "#%4d   " $shots
  printf "Xc = %4d  " $xCoord
  printf "Yc = %4d  " $yCoord
  printf "Distance = %5d  " $distance         #   
                                              #+  ,
                                              #+   (0,0).

  if [ "$distance" -le "$DIMENSION" ]
  then
    echo -n "!  "                         #   
    ((splashes++))
  else
    echo -n "!    "                        #    
    ((thuds++))
  fi

  Pi=$(echo "scale=9; $PMULTIPLIER*$splashes/$shots" | bc)
  #    4.0.
  echo -n "PI ~ $Pi"
  echo

done

echo
echo " $shots ,    \"\"  $Pi."
#    ...
#  -       .
echo

# }

exit 0

#      ,     
#+       .
#
#    ,     
#  1)     .
#  2)   ""     
#+          .
