#!/bin/bash
# blotout.sh:   .

#         ,
#+        .
#        
#+     .

PASSES=7         #    .
BLOCKSIZE=1      #   / / /dev/urandom    ,
                 #+      .
E_BADARGS=70
E_NOT_FOUND=71
E_CHANGED_MIND=72

if [ -z "$1" ]   #    .
then
  echo " : `basename $0` filename"
  exit $E_BADARGS
fi

file=$1

if [ ! -e "$file" ]
then
  echo " \"$file\"  ."
  exit $E_NOT_FOUND
fi

echo; echo -n "    ,    \"$file\" (y/n)? "
read answer
case "$answer" in
[nN]) echo "?  ."
      exit $E_CHANGED_MIND
      ;;
*)    echo "  \"$file\".";;
esac


flength=$(ls -l "$file" | awk '{print $5}')  #    5 --   .

pass_count=1

echo

while [ "$pass_count" -le "$PASSES" ]
do
  echo " #$pass_count"
  sync         #  .
  dd if=/dev/urandom of=$file bs=$BLOCKSIZE count=$flength
               #    .
  sync         #   .
  dd if=/dev/zero of=$file bs=$BLOCKSIZE count=$flength
               #   .
  sync         #   .
  let "pass_count += 1"
  echo
done


rm -f $file    #    "" .
sync           #     .

echo " \"$file\" ."; echo


#    ,       .
#+      "shred",
#+     GNU "fileutils".

#     ,      .
#  ...
#+        
#+   


#  Tom Vier   "wipe",     
#+    .
#     http://www.ibiblio.org/pub/Linux/utils/file/wipe-2.0.0.tar.bz2

#         ,
#+    cnfnmt Peter Gutmann,
#+     "Secure Deletion of Data From Magnetic and Solid-State Memory".
#         http://www.cs.auckland.ac.nz/~pgut001/pubs/secure_del.html


exit 0
