#!/bin/bash
# bin-grep.sh:     .

#  "grep"   .
#   "grep -a"

E_BADARGS=65
E_NOFILE=66

if [ $# -ne 2 ]
then
  echo " : `basename $0` string filename"
  exit $E_BADARGS
fi

if [ ! -f "$2" ]
then
  echo " \"$2\"  ."
  exit $E_NOFILE
fi


for word in $( strings "$2" | grep "$1" )
#  "strings"      .
#       "grep",   .
do
  echo $word
done

#   S.C.,    for   
#    strings "$2" | grep "$1" | tr -s "$IFS" '[\n*]'


#    :  "./bin-grep.sh mem /bin/ls"

exit 0
