:
##########################################################################
# Shellscript:	base.sh -       (Bourne Shell)
# Author     :	Heiner Steven (heiner.steven@odn.de)
# Date       :	07-03-95
# Category   :	Desktop
# $Id: base.sh,v 1.2 2000/02/06 19:55:35 heiner Exp $
##########################################################################
# Description
#
# Changes
# 21-03-95 stv	 ,     0xb (0.2)
##########################################################################

# ==>       .
# ==>    .

NOARGS=65
PN=`basename "$0"`			       #  
VER=`echo '$Revision: 1.2 $' | cut -d' ' -f2`  # ==> VER=1.2

Usage () {
    echo "$PN -      , $VER (stv '95)
 : $PN [number ...]

   ,     stdin.
  :
                     0b ( 0b1100)
               0  ( 014)
            0x ( 0xc)
                  ( 12)" >&2
    exit $NOARGS
}   # ==>      .

Msg () {
    for i   # ==> []  .
    do echo "$PN: $i" >&2
    done
}

Fatal () { Msg "$@"; exit 66; }

PrintBases () {
    #   
    for i      # ==> []  ...
    do         # ==>      .
	case "$i" in
	    0b*)		ibase=2;;	# 
	    0x*|[a-f]*|[A-F]*)	ibase=16;;	# 
	    0*)			ibase=8;;	# 
	    [1-9]*)		ibase=10;;	# 
	    *)
		Msg "   $i -  "
		continue;;
	esac

	#          (  bc)
	number=`echo "$i" | sed -e 's:^0[bBxX]::' | tr '[a-f]' '[A-F]'`
	# ==>  "/",    ":"    sed.

	#     
	dec=`echo "ibase=$ibase; $number" | bc`  # ==> 'bc'   .
	case "$dec" in
	    [0-9]*)	;;       #   
	    *)		continue;; # : 
	esac

	#      .
	# ==> ' ' --    'bc'.
	echo `bc <<!
	    obase=16; "hex="; $dec
	    obase=10; "dec="; $dec
	    obase=8;  "oct="; $dec
	    obase=2;  "bin="; $dec
!
    ` | sed -e 's: :	:g'

    done
}

while [ $# -gt 0 ]
do
    case "$1" in
	--)	shift; break;;
	-h)	Usage;;          # ==>   .
	-*)	Usage;;
	*)	break;;          #  
    esac   # ==>      .
    shift
done

if [ $# -gt 0 ]
then
    PrintBases "$@"
else					#   stdin
    while read line
    do
	PrintBases $line
    done
fi
