#!/bin/bash
#   .

#  (( ... ))   .
#       [ ... ] !

(( 0 ))
echo "  \"(( 0 ))\":  $?."         # 1

(( 1 ))
echo "  \"(( 1 ))\":  $?."         # 0

(( 5 > 4 ))                                   # true
echo "  \"(( 5 > 4 ))\":  $?."     # 0

(( 5 > 9 ))                                   # false
echo "  \"(( 5 > 9 ))\":  $?."     # 1

(( 5 - 5 ))                                   # 0
echo "  \"(( 5 - 5 ))\":  $?."     # 1

(( 5 / 4 ))                                   # ,   
echo "  \"(( 5 / 4 ))\":  $?."     # 0

(( 1 / 2 ))                                   #   < 1.
echo "  \"(( 1 / 2 ))\":  $?."     #   0.
                                              # 1

(( 1 / 0 )) 2>/dev/null                       #   0.
echo "  \"(( 1 / 0 ))\":  $?."     # 1

#     "2>/dev/null" ?
#  ,   ?
#      .

exit 0
